<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use RalphJSmit\Laravel\SEO\Support\HasSEO;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Blog extends BaseModel implements HasMedia
{
    use HasFactory;
    use HasUuids;
    use InteractsWithMedia;
    use HasSEO;

    protected $table = 'blogs';
    protected $fillable = [
        'title_ar',
        'title_en',
        'slug',
        'author_ar',
        'author_en',
        'content_ar',
        'content_en',
        'status',
        'is_featured',
        'category_id',
        'video_url',
        'video_type',
    ];

    protected $casts = [
        'status' => 'boolean',
        'is_featured' => 'boolean',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * Apply all relevant Sizes filters
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeIsFeatured(Builder $query): Builder
    {
        return $query->where('is_featured', true);
    }

    /**
     * Apply all relevant Sizes filters
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeIsNotFeatured(Builder $query): Builder
    {
        return $query->where('is_featured', false);
    }
}
