<?php

namespace App\Repositories;


use App\Models\ContactInfo;
use App\Repositories\Interfaces\ContactInfoRepositoryInterface;
use Illuminate\Database\Eloquent\Model;

class ContactInfoRepository extends Repository implements ContactInfoRepositoryInterface
{
    public function __construct(ContactInfo $model)
    {
        $this->setModel($model);
    }

    /**
     * Get the first contact info record.
     *
     * @return Model|null
     */
    public function first(): ?Model
    {
        return $this->getModel()->first();
    }

}

