<?php

namespace App\Services\Website\Courses;

use App\Repositories\Interfaces\CourseRepositoryInterface;
use App\Services\BaseService;

class GetCourseBySlugService extends BaseService
{
    private string $slug;

    public function __construct(
        private readonly CourseRepositoryInterface $bookRepository
    )
    {
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug): self
    {
        $this->slug = $slug;
        return $this;
    }


    public function execute()
    {
        return $this->bookRepository->getBySlug($this->slug);
    }
}
