<?php

namespace App\Services\Website\Profile;

use App\DTOs\Api\Profile\GetProfileDto;
use App\Models\User;
use App\Repositories\Interfaces\UserRepositoryInterface;
use Exception;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;

class GetUserProfileService
{
    private GetProfileDto $dto;
    private ?Model $profile;
    private User $user;
    /**
     * @param UserRepositoryInterface $userRepository
     */
    public function __construct(
        private readonly UserRepositoryInterface $userRepository
    )
    {
    }

    /**
     * @param GetProfileDto $dto
     * @return self
     */
    final public function setDto(GetProfileDto $dto): self
    {
        $this->dto = $dto;
        return $this;
    }

    /**
     * @throws Exception
     */
    final public function execute(): self
    {
        $this->profile = $this->userRepository->get($this->dto, $this->user);
        return $this;
    }

    /**
     * @param User|Authenticatable $user
     * @return self
     */
    final public function setUser(User|Authenticatable $user): self
    {
        $this->user = $user;
        return $this;
    }

    /**
     * @return Model|null
     */
    final public function getProfile(): ?Model
    {
        return $this->profile;
    }
}
