<?php use App\Enums\Media\MediaCollection; ?>
<?php use Carbon\Carbon; ?>

<?php $__env->startSection('page-name', __('lang.Blog')); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header Section -->
    <section class="header-bg">
        <div class="container-fluid p-100">
            <div class="header-section">
                <div class="overlay"></div>
                <div class="header-content">
                    <p class="small-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(__('lang.home')); ?>

                        <img
                            src="<?php echo e(asset('website/assets/images/smallchervon left.svg')); ?>"
                            alt="<?php echo e(__('lang.arrow')); ?>"
                            class="breadcrumb-arrow"
                            style="<?php echo e(app()->getLocale() === 'ar' ? 'transform: rotate(180deg)' : ''); ?>">

                        <?php echo e(__('lang.blog')); ?>

                    </p>
                    <h1 class="header-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(__('lang.kyddzo_blog')); ?>

                    </h1>
                    <p class="header-subtitle" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo getColumn($coverDescription, 'content'); ?>

                    </p>

                    <form method="GET" action="<?php echo e(route('blogs.index')); ?>" class="search-input-container"
                          data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <input type="text" name="search" class="form-control search-input-blog"
                               placeholder="<?php echo e(__('lang.search')); ?>" value="<?php echo e(request('search')); ?>">
                        <button type="submit" class="search-button">
                            <img src="<?php echo e(asset('website/assets/images/search-icon.svg')); ?>"
                                 alt="<?php echo e(__('lang.search_icon')); ?>">
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- Blog Card Section -->
    <section class="blog-section">
        <div class="container-fluid  p-100">

            <div class="row">
                <div class="col-md-3">
                    <div class="category-section">
                        <h5 class="mb-2 d-flex justify-content-between align-items-center">
                            <span><?php echo e(__('lang.Category')); ?></span>
                        </h5>

                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">
                                <input class="form-check-input me-2 checkbox-custom" type="checkbox" id="all"
                                       value="all">
                                <label class="form-check-label" for="all"><?php echo e(__("lang.All")); ?></label>
                            </li>

                            <!-- Categories dynamically loaded from the backend -->
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item">
                                    <input class="form-check-input me-2 checkbox-custom" type="checkbox"
                                           <?php echo e(in_array( $category->id, request('categories') ?? []) ? 'checked' : ""); ?>

                                           id="category-<?php echo e($category->id); ?>" value="<?php echo e($category->id); ?>">
                                    <label class="form-check-label"
                                           for="category-<?php echo e($category->id); ?>"><?php echo e(getColumn($category, 'name')); ?></label>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                        <button id="filterProducts" class="buy-now-btn aos-init aos-animate mt-3">Filter</button>
                    </div>
                </div>

                <div class="col-md-9">
                    <h5 class="articles-text-blog" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-offset="10"> <?php echo e(__('lang.articles_count', ['count' => $blogs->count()])); ?></h5>
                    <div class="row">
                        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!-- First Blog Card -->
                            <div class="col-md-4 col-12 mb-4">
                                <div class="card blog-card" data-aos="fade-up" data-aos-duration="1000"
                                     data-aos-offset="10">
                                    <div class="position-relative">
                                        <a
                                           href="<?php echo e(route('blogs.show', ['slug' => $blog->slug])); ?>">
                                            <img
                                                src="<?php echo e($blog->getFirstMediaUrl(app()->getLocale() == 'ar' ? MediaCollection::LIST_BLOG_IMAGE_ARABIC->value : MediaCollection::LIST_BLOG_IMAGE_ENGLISH->value)); ?>"
                                                class="card-blog-img" alt="Blog Image">
                                        </a>
                                        <span class="custom-badge-blog" data-aos="fade-up" data-aos-duration="1000"
                                              data-aos-offset="10"> <?php echo e(getColumn($blog->category, 'name')); ?></span>
                                    </div>
                                    <div class="card-body">
                                        <small class="text-muted d-block mb-2" data-aos="fade-up"
                                               data-aos-duration="1000"
                                               data-aos-offset="10"><?php echo e(Carbon::create($blog->created_at)->format('F d, Y')); ?></small>
                                        <a class="card-blog-title"
                                           href="<?php echo e(route('blogs.show', ['slug' => $blog->slug])); ?>">
                                            <h5 class="card-blog-title" data-aos="fade-up" data-aos-duration="1000"
                                                data-aos-offset="10"> <?php echo e(getColumn($blog, "title")); ?></h5>
                                        </a>
                                        <a href="<?php echo e(route('blogs.show', ['slug' => $blog->slug])); ?>"
                                           class="seedetails-blog" data-aos="fade-up" data-aos-duration="1000"
                                           data-aos-offset="10">  <?php echo e(__('lang.see_details')); ?> <img
                                                src="<?php echo e(asset('website/assets/images/blog-arrow.svg')); ?>"
                                                alt="<?php echo e(__('lang.details_icon')); ?>"></a>
                                    </div>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
    </section>


    <!-- Pagination Section -->
    <nav aria-label="Page navigation" class="custom-pagination">
        <ul class="pagination justify-content-center">
            <?php echo e($blogs->appends(request()->query())->links("pagination::bootstrap-4")); ?>

        </ul>
    </nav>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("scripts"); ?>

    <script>
        $(document).ready(function () {
            $('#filterProducts').on('click', function () {
                var selectedCategories = [];
                var allChecked = $('#all').is(':checked');

                // Check if "All" is checked
                if (!allChecked) {
                    // Collect selected categories if "All" is not checked
                    $('.checkbox-custom').each(function () {
                        if ($(this).is(':checked') && $(this).val() !== 'all') {
                            selectedCategories.push($(this).val());
                        }
                    });
                }

                // Build the query string with categories
                var queryString = '';
                if (selectedCategories.length > 0) {
                    queryString = '?categories[]=' + selectedCategories.join('&categories[] =');
                }

                // Redirect to the same page with query parameters
                var currentUrl = window.location.origin + window.location.pathname;
                window.location.href = currentUrl + queryString;
            });
        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intcoredev/public_html/kydzoo.intcore.dev/resources/views/website/blogs.blade.php ENDPATH**/ ?>