<div class="col-md-3">
    <div class="category-section">
        <h5 class="mb-2 d-flex justify-content-between align-items-center">
            <span><?php echo e(__('lang.Category')); ?></span>
        </h5>

        <ul class="list-group list-group-flush">
            <li class="list-group-item">
                <input class="form-check-input me-2 checkbox-custom" type="checkbox" id="all" value="all">
                <label class="form-check-label" for="all"><?php echo e(__("lang.All")); ?></label>
            </li>

            <!-- Categories dynamically loaded from the backend -->
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item">
                    <input class="form-check-input me-2 checkbox-custom" type="checkbox"
                           <?php echo e(in_array( $category->id, request('categories') ?? []) ? 'checked' : ""); ?>

                           id="category-<?php echo e($category->id); ?>" value="<?php echo e($category->id); ?>">
                    <label class="form-check-label" for="category-<?php echo e($category->id); ?>"><?php echo e(getColumn($category, 'name')); ?></label>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        <button id="filterProducts" class="buy-now-btn aos-init aos-animate mt-3">Filter</button>
    </div>
</div>


<?php $__env->startPush("scripts"); ?>

    <script>
        $(document).ready(function() {
            $('#filterProducts').on('click', function() {
                var selectedCategories = [];
                var allChecked = $('#all').is(':checked');

                // Check if "All" is checked
                if (!allChecked) {
                    // Collect selected categories if "All" is not checked
                    $('.checkbox-custom').each(function() {
                        if ($(this).is(':checked') && $(this).val() !== 'all') {
                            selectedCategories.push($(this).val());
                        }
                    });
                }

                // Build the query string with categories
                var queryString = '';
                if (selectedCategories.length > 0) {
                    queryString = '?categories[]=' + selectedCategories.join('&categories[] =');
                }

                // Redirect to the same page with query parameters
                var currentUrl = window.location.origin + window.location.pathname;
                window.location.href = currentUrl + queryString;
            });
        });

    </script>

<?php $__env->stopPush(); ?>
<?php /**PATH /home/intcoredev/public_html/kydzoo.intcore.dev/resources/views/website/productComponent/index/category-box.blade.php ENDPATH**/ ?>